/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
//
// Initialy this shader behaved very differently dependinig on whether I was
// using my laptop's Intel Integrated Graphics processor or its NVIDIA  GPU,
// with the NVIDIA GPU always resulting in a plain black background.  I have
// therefore modified it in order to make it work and,  although I eventualy
// found that only a simple change was needed, in doing so I have simplified
// it by deleting unused parts of the code and be rearranging what was left.
// It now woks on both GPUs, TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// While debugging the problem using the NVIDIA GPU I found that simple changes
// to parameters used y the knot function produced images that were at least as
// pleasing as the original hard codec version, so I provided the following set
// of uniforms to control the shader from the scene file.  The  values for each
// of the components of KnotForm should typicaly be in the range -10.0 to 10.0.
// The default,  also used if (0.0,0.0) is explicitly specified,  is (-1.0,1.0)
// which corresponds to the original hard code values. TheEmu. 

uniform float Rate;
uniform vec2  KnotForm;

   float rate = (Rate==0.0) ? 8.0 : Rate;
   vec2  form = (KnotForm==vec2(0.0)) ? vec2(-1.0,1.0) : KnotForm;

/////////////////////////////////////////////////////////////////////////////////

#define TAU 6.28318530718
#define PI  ( TAU / 2.0 )

#define maxSteps 100 // May be reduced if you have performance problems.

vec3 rgb2hsv ( vec3 c )
 {
    vec4 K = vec4 ( 0.0, -1.0/3.0, 2.0/3.0, -1.0 );
    vec4 p = mix ( vec4(c.bg,K.wz), vec4(c.gb,K.xy), step(c.b,c.g) );
    vec4 q = mix ( vec4(p.xyw,c.r), vec4(c.r,p.yzx), step(p.x,c.r) );

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;

    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);

 }

vec3 hsv2rgb ( vec3 c )
 {
   vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
   vec3 p = abs ( fract(c.xxx + K.xyz) * 6.0 - K.www );

   return c.z * mix ( K.xxx, clamp(p-K.xxx,0.0,1.0), c.y );

 }

// The following simple functions are implemented as functions for efficiency
// because I was getting a jerky display when using my Intel GPU. TheEmu.

#define fbm2(uv) fbm ( uv + 4.0*vec2 ( fbm(uv), fbm(uv+vec2(5.2,1.3))  ) )
#define add(a,b) vec2 ( min(a.x,b.x), (a.x<b.x) ? a.y : b.y )
#define noise(uv) ( sin(1.5*uv.x) * sin(1.5*uv.y) )

const mat2 mFbm = mat2 ( 0.80,  0.60, -0.60,  0.80 );

float fbm ( vec2 uv )
 {
   float f = 0.0;

   f += 0.5000*noise(uv); uv = mFbm*uv*2.02;
   f += 0.2500*noise(uv); uv = mFbm*uv*2.03;
   f += 0.1250*noise(uv); uv = mFbm*uv*2.01;
   f += 0.0625*noise(uv);

   return f/0.9375;

 }

vec2 knot ( in vec3 p )
 {

   p.z = cos(p.z);

   float m = length(p+fbm2(p.xy)) * 0.1;
   float r = length(p.xy);
   float a = atan(p.y, p.x);
   float b = rate*a;

   a = mod(a,0.001*TAU) - 0.001*TAU/2.0;

   p.xy = r * vec2 ( cos(a), sin(a) );
   p.x -= 6.0;

   p.xz = cos(b)*p.xz + sin(b)*p.zx*form; // Generalised version. TheEmu.
   p.x  = abs(p.x) - 1.35;

   vec2 q = vec2 ( length(p)-1.0, m );
   return add ( vec2(8.0), q );

 }

mat3 setLookAt ( in vec3 ro, in vec3 ta, in float cr )
 {
   vec3 cw = normalize(ta-ro);
   vec3 cp = vec3(sin(cr), cos(cr),0.0);
   vec3 cu = normalize( cross(cw,cp) );
   vec3 cv = normalize( cross(cu,cw) );

   return mat3 ( cu, cv, cw );

}

void mainImage ( out vec4 fragColor, in vec2 fragCoord )
 {
   vec2 p = 2.0 * fragCoord.xy/iResolution.xy  -  1.0;
   p.x *= iResolution.x / iResolution.y;

   // camera

   vec3 ro = vec3 ( 0.0, 0.0, 16.0+iGlobalTime*5.0 );
   vec3 ta = vec3(0.0);

   float roll = iGlobalTime*0.1;

   // camera tx

   mat3 ca = setLookAt( ro, ta, roll );
   vec3 rd = normalize( ca * vec3(p.xy,1.75) );

   float t    = 0.0;   // Near
   float tmax = 120.0; // Far

   float h    = 0.001;
   float hmax = 0.001;

   vec2 scn = vec2(0.0);
   vec3 col = vec3(0.0);
   vec3 pos = vec3(0.0);

   int stepN = 0;

   for ( stepN = 0; stepN < maxSteps; stepN++ )
    {
      if ( h < hmax ) { break; }
      if ( t > tmax ) { break; }

      pos = ro + rd*t;
      scn = knot ( pos );

      h = scn.x;
      t += h;

    }

   if ( t < tmax )
    {
      float f = 1.0 - float(stepN)/float(maxSteps);
      f = 1.0 - exp ( (1.0/8.0) / log(f) );

      col = rgb2hsv ( vec3(0.5,0.1,0.3) );

      col.x += scn.y + 0.1 + pos.z*0.1;
      col.y = 0.85;
      col.z = 1.40;

      col = hsv2rgb(col) * f;

    }

  fragColor = vec4 ( col, 1.0 );

 }

void main( void )
 { mainImage( gl_FragColor, gl_FragCoord.xy );
 }